#!/bin/bash

CurrPath=$(cd `dirname $0`; pwd)

#install service

#安装usb服务
#param1 服务名
InstallService (){
    echo "begin to install $1"
    name=$1
    service=$1".service"
    if test -e /lib/systemd/system/$service
    then
        systemctl stop $name
        systemctl disable $name
        rm -f /lib/systemd/system/$service
        systemctl daemon-reload
    fi
    cp $service /lib/systemd/system/
    systemctl daemon-reload
    systemctl enable $service
    systemctl start $service
}

#安装剪切板fuse库
InstallClipBoard(){
    echo "begin to install clipboard $InstallPath"

    #获取clipboard安装路径
    cd ../
    destPath=$(pwd)
    cd "$CurrPath"

    #安装clipboard库
    cd ./clipboardlib
    chmod +x *
    bash install_clipboard.sh $destPath

    cd "$CurrPath"

    echo "end install clipboard"
}
#合并配置value项
MergeValue(){
#echo "$1"
#str=$1
IFS='='
arr=($1)

unset IFS
IFS=';'
b=(${arr[1]})

ub=($(echo "${b[@]}" | tr ' ' '\n' | sort -u | tr '\n' ' '))

trets="$(echo ${arr[0]}"="$(echo ${ub[@]}))"

echo $trets
unset IFS
}


#安装配置文件
InstallMainConf(){
    echo "begin to install main.conf"
    mkdir -p /usr/local/vdi/

    if [ -f /usr/local/vdi/main.conf ]
    then
	    echo "main.conf is exist, do merge to file"
awk -F= '
FILENAME==ARGV[1]{
	a[FNR]=$1;
	b[FNR]=$2;
        if ( $1 == "discorking" ){
		print $1"="$2
        }
};
FILENAME==ARGV[2]{
	for ( i=1 ; i in a ; i++ ){
		if(a[i]==$1){
			if ( $1 != "discorking" ){
                            if ( substr(b[i], length(b[i]), 1) == ";" ){
			        print a[i]"="$2""b[i]
                            }
                            else {
                                print a[i]"="b[i]
                            }
		        }
			break;
		}
	}
	if(i in a) {}
        else{
		print $1"="$2
	}
}' /usr/local/vdi/main.conf main.conf > /usr/local/vdi/main.new.conf
        mv /usr/local/vdi/main.conf /usr/local/vdi/main.conf.bak
        cat /usr/local/vdi/main.new.conf | while read line; do
            MergeValue "$line" >> /usr/local/vdi/main.conf
        done
        sed -i 's/ /;/g' /usr/local/vdi/main.conf
	rm main.conf
	rm /usr/local/vdi/main.new.conf
	ln -sf /usr/local/vdi/main.conf main.conf
    else
        echo "first time install main.conf"
        mv main.conf /usr/local/vdi/main.conf
        ln -sf /usr/local/vdi/main.conf main.conf
    fi
}

#安装打印重定向配置文件
InstallPrintRedirConf(){
    echo "begin to install printredir.json"
    mkdir -p /etc/vdiprint/

    if [ -f /etc/vdiprint/printredir.json ]
    then
        echo "printredir.json is exist in /etc/vdiprint/, do merge to file."
        ./printservice merge-config
        rm printredir.json
    else
        echo "install printredir.json"
        mv printredir.json /etc/vdiprint/printredir.json
        chmod 666 /etc/vdiprint/printredir.json
    fi
    echo "end to install printredir.json"

    echo "begin to install printservice"
    ./printservice install
    echo "end to install printservice"
}

cd "$CurrPath"

mypath=\"$CurrPath\"

echo $mypath

echo sed -i "s#\$(InstallPath)#$mypath#g" `find ./ -name "*.service"`
sed -i "s#\$(InstallPath)#$mypath#g" `find ./ -name "*.service"`

InstallMainConf
InstallPrintRedirConf
InstallService eveusb
InstallService comservice
InstallService lptservice
InstallService camrdr
InstallService diskmapping
InstallClipBoard
InstallService printservice
if [ ! -d "/userdata/share" ];
then
  mkdir -p /userdata/share
else
  echo "/userdata/share already exist"
fi

chmod 777 /userdata/share
chmod a+x *

cp -rf ./ota_usb_retain_file /usr/local/etc/
chmod 440 /usr/local/etc/ota_usb_retain_file

echo "add printer boot task"
echo @reboot root \"$CurrPath/printservice\" delete-cache >> /etc/crontab
